/**
 * \file: common.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * \component: Secure Data Container
 * \brief : defines shared between imx6 part in khd and libsdc
 *
 * <b>SDC private header</b>
 *
 * \author: Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __SDC_LIB_CAAM_COMMON_H_
#define __SDC_LIB_CAAM_COMMON_H_

#include <linux/caam_key.h>

/* defines used to distinguish normal keystore keys and product keys */
/* normal keystore needs to use 0 as this is the default used for old keystore keys */
#define CAAM_IMX6_USER_FLAGS__NORMAL_KEYSTORE_KEY   ((0<<CAAM_KEY_FLAG_USER_SHIFT) & CAAM_KEY_FLAG_USER_MASK)
#define CAAM_IMX6_USER_FLAGS__PRODUCT_KEYSTORE_KEY  ((1<<CAAM_KEY_FLAG_USER_SHIFT) & CAAM_KEY_FLAG_USER_MASK)
#define CAAM_IMX6_USER_FLAGS__BUILTIN_KEY           ((2<<CAAM_KEY_FLAG_USER_SHIFT) & CAAM_KEY_FLAG_USER_MASK)

#endif
